<?php
/**
 * IntegratorCardPayloadResponse
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  HubSpot\Client\Crm\Extensions\Cards
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Public App Crm Cards
 *
 * Allows an app to extend the CRM UI by surfacing custom cards in the sidebar of record pages. These cards are defined up-front as part of app configuration, then populated by external data fetch requests when the record page is accessed by a user.
 *
 * The version of the OpenAPI document: v3
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 7.3.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace HubSpot\Client\Crm\Extensions\Cards\Model;

use \ArrayAccess;
use \HubSpot\Client\Crm\Extensions\Cards\ObjectSerializer;

/**
 * IntegratorCardPayloadResponse Class Doc Comment
 *
 * @category Class
 * @description The card details payload, sent to HubSpot by an app in response to a data fetch request when a user visits a CRM record page.
 * @package  HubSpot\Client\Crm\Extensions\Cards
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class IntegratorCardPayloadResponse implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'IntegratorCardPayloadResponse';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'response_version' => 'string',
        'card_label' => 'string',
        'all_items_link_url' => 'string',
        'total_count' => 'int',
        'top_level_actions' => '\HubSpot\Client\Crm\Extensions\Cards\Model\TopLevelActions',
        'sections' => '\HubSpot\Client\Crm\Extensions\Cards\Model\IntegratorObjectResult[]'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'response_version' => null,
        'card_label' => null,
        'all_items_link_url' => null,
        'total_count' => 'int32',
        'top_level_actions' => null,
        'sections' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'response_version' => false,
        'card_label' => false,
        'all_items_link_url' => false,
        'total_count' => false,
        'top_level_actions' => false,
        'sections' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'response_version' => 'responseVersion',
        'card_label' => 'cardLabel',
        'all_items_link_url' => 'allItemsLinkUrl',
        'total_count' => 'totalCount',
        'top_level_actions' => 'topLevelActions',
        'sections' => 'sections'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'response_version' => 'setResponseVersion',
        'card_label' => 'setCardLabel',
        'all_items_link_url' => 'setAllItemsLinkUrl',
        'total_count' => 'setTotalCount',
        'top_level_actions' => 'setTopLevelActions',
        'sections' => 'setSections'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'response_version' => 'getResponseVersion',
        'card_label' => 'getCardLabel',
        'all_items_link_url' => 'getAllItemsLinkUrl',
        'total_count' => 'getTotalCount',
        'top_level_actions' => 'getTopLevelActions',
        'sections' => 'getSections'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }

    public const RESPONSE_VERSION_V1 = 'v1';
    public const RESPONSE_VERSION_V3 = 'v3';

    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getResponseVersionAllowableValues()
    {
        return [
            self::RESPONSE_VERSION_V1,
            self::RESPONSE_VERSION_V3,
        ];
    }

    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->setIfExists('response_version', $data ?? [], null);
        $this->setIfExists('card_label', $data ?? [], null);
        $this->setIfExists('all_items_link_url', $data ?? [], null);
        $this->setIfExists('total_count', $data ?? [], null);
        $this->setIfExists('top_level_actions', $data ?? [], null);
        $this->setIfExists('sections', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        $allowedValues = $this->getResponseVersionAllowableValues();
        if (!is_null($this->container['response_version']) && !in_array($this->container['response_version'], $allowedValues, true)) {
            $invalidProperties[] = sprintf(
                "invalid value '%s' for 'response_version', must be one of '%s'",
                $this->container['response_version'],
                implode("', '", $allowedValues)
            );
        }

        if ($this->container['total_count'] === null) {
            $invalidProperties[] = "'total_count' can't be null";
        }
        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets response_version
     *
     * @return string|null
     */
    public function getResponseVersion()
    {
        return $this->container['response_version'];
    }

    /**
     * Sets response_version
     *
     * @param string|null $response_version response_version
     *
     * @return self
     */
    public function setResponseVersion($response_version)
    {
        if (is_null($response_version)) {
            throw new \InvalidArgumentException('non-nullable response_version cannot be null');
        }
        $allowedValues = $this->getResponseVersionAllowableValues();
        if (!in_array($response_version, $allowedValues, true)) {
            throw new \InvalidArgumentException(
                sprintf(
                    "Invalid value '%s' for 'response_version', must be one of '%s'",
                    $response_version,
                    implode("', '", $allowedValues)
                )
            );
        }
        $this->container['response_version'] = $response_version;

        return $this;
    }

    /**
     * Gets card_label
     *
     * @return string|null
     */
    public function getCardLabel()
    {
        return $this->container['card_label'];
    }

    /**
     * Sets card_label
     *
     * @param string|null $card_label The label to be used for the `allItemsLinkUrl` link (e.g. 'See more tickets'). If not provided, this falls back to the card's title.
     *
     * @return self
     */
    public function setCardLabel($card_label)
    {
        if (is_null($card_label)) {
            throw new \InvalidArgumentException('non-nullable card_label cannot be null');
        }
        $this->container['card_label'] = $card_label;

        return $this;
    }

    /**
     * Gets all_items_link_url
     *
     * @return string|null
     */
    public function getAllItemsLinkUrl()
    {
        return $this->container['all_items_link_url'];
    }

    /**
     * Sets all_items_link_url
     *
     * @param string|null $all_items_link_url URL to a page the integrator has built that displays all details for this card. This URL will be displayed to users under a `See more [x]` link if there are more than five items in your response, where `[x]` is the value of `itemLabel`.
     *
     * @return self
     */
    public function setAllItemsLinkUrl($all_items_link_url)
    {
        if (is_null($all_items_link_url)) {
            throw new \InvalidArgumentException('non-nullable all_items_link_url cannot be null');
        }
        $this->container['all_items_link_url'] = $all_items_link_url;

        return $this;
    }

    /**
     * Gets total_count
     *
     * @return int
     */
    public function getTotalCount()
    {
        return $this->container['total_count'];
    }

    /**
     * Sets total_count
     *
     * @param int $total_count The total number of card properties that will be sent in this response.
     *
     * @return self
     */
    public function setTotalCount($total_count)
    {
        if (is_null($total_count)) {
            throw new \InvalidArgumentException('non-nullable total_count cannot be null');
        }
        $this->container['total_count'] = $total_count;

        return $this;
    }

    /**
     * Gets top_level_actions
     *
     * @return \HubSpot\Client\Crm\Extensions\Cards\Model\TopLevelActions|null
     */
    public function getTopLevelActions()
    {
        return $this->container['top_level_actions'];
    }

    /**
     * Sets top_level_actions
     *
     * @param \HubSpot\Client\Crm\Extensions\Cards\Model\TopLevelActions|null $top_level_actions top_level_actions
     *
     * @return self
     */
    public function setTopLevelActions($top_level_actions)
    {
        if (is_null($top_level_actions)) {
            throw new \InvalidArgumentException('non-nullable top_level_actions cannot be null');
        }
        $this->container['top_level_actions'] = $top_level_actions;

        return $this;
    }

    /**
     * Gets sections
     *
     * @return \HubSpot\Client\Crm\Extensions\Cards\Model\IntegratorObjectResult[]|null
     */
    public function getSections()
    {
        return $this->container['sections'];
    }

    /**
     * Sets sections
     *
     * @param \HubSpot\Client\Crm\Extensions\Cards\Model\IntegratorObjectResult[]|null $sections A list of up to five valid card sub categories.
     *
     * @return self
     */
    public function setSections($sections)
    {
        if (is_null($sections)) {
            throw new \InvalidArgumentException('non-nullable sections cannot be null');
        }
        $this->container['sections'] = $sections;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


